package cn.com.duiba.tuia.activity.center.api.constant.commercial.plant;

import static cn.com.duiba.tuia.activity.center.api.constant.commercial.plant.PlantProp.KETTLE;
import static cn.com.duiba.tuia.activity.center.api.constant.commercial.plant.PlantProp.PESTICIDE;

/*
 * 土地会遇到的灾害类型
 * */
public enum PlantLandStatus {

    NORMAL(0, "正常"),
    DRY(1, "干涸", KETTLE),
    THIRSTY(2, "缺水", KETTLE),
    WORMS(3, "虫害", PESTICIDE),
    ;

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public PlantProp getResolveProp() {
        return resolveProp;
    }

    private PlantProp resolveProp;

    private int code;

    private String desc;

    PlantLandStatus(int code, String desc, PlantProp prop) {
        this.resolveProp = prop;
        this.code = code;
        this.desc = desc;
    }

    PlantLandStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
