package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 用户设备类型
 * 适用于搜狗、猎豹、暴风 adx device type
 *
 * @author hillchen
 * @create 2019/3/4 22:09
 */
public enum UserClientType {
    UNKNOW(0,"未知"),
    MOV(1,"移动端/平板端"),
    PC(2,"PC 端"),
    TV(3,"电视端"),
    PHONE(4,"手机端"),
    TABLET(5,"平板端"),
    CONTOOL(6,"连接设备"),
    TVBOX(7,"电视盒")
    ;

    private int type;

    private String desc;

    UserClientType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer clientType){
        return Objects.nonNull(clientType) && Objects.equals(type,clientType) || this.equals(UNKNOW);
    }

    /**
     * 推啊字典项都是参考搜狗字典项,猎豹字典项在搜狗范围内重叠
     * @param clientType
     * @return
     */
    public static UserClientType convertToTuiaType(Integer clientType){
        for(UserClientType connetType: UserClientType.values()){
            if(connetType.isSameType(clientType)){
                return connetType;
            }
        }
        return UNKNOW;
    }
}
