package cn.com.duiba.tuia.activity.center.api.constant.story;

import java.util.Objects;

/**
 * StoryPrizeType
 *
 * @author huangruodan
 * @date 2019/5/21
 */
public enum StoryPrizeType {
    CASH(1, "现金"),
    COIN(2, "金币"),
    LUCKY(3, "福袋"),
    THANKS(4, "谢谢参与");

    private Integer prizeType;

    private String desc;

    StoryPrizeType(Integer prizeType, String desc) {
        this.prizeType = prizeType;
        this.desc = desc;
    }

    /**
     * 获取奖励类型枚举
     *
     * @param type 奖励类型
     * @return 枚举
     */
    public static StoryPrizeType valueOf(Integer type) {
        for (StoryPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getPrizeType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(Integer prizeType) {
        this.prizeType = prizeType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
