package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.IdeaPictureDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.IdeaSortReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ResourceIdeaPageReq;
import cn.com.duiba.tuia.activity.center.api.dto.rsp.ResourceIdeaThreeRsp;

import java.util.List;

/**
 * 创意服务
 *
 * @author weny.cai
 * @date 2018/12/3 14:26
 **/
@AdvancedFeignClient
public interface RemoteResourceIdeaService {

    boolean add(ResourceIdeaDto dto) throws BizException;

    boolean update(ResourceIdeaDto dto) throws BizException;

    PageDto<ResourceIdeaDto> pageQuery(ResourceIdeaPageReq req);

    List<ResourceIdeaDto> queryListByResourceId(Long resourceId);

    Boolean sortIdea(IdeaSortReq req) throws BizException;

    ResourceIdeaDto getIdeaById(Long id);

    boolean changeSwitchStateById(Long id, Integer switchState);

    List<IdeaPictureDto> getPictureByIdeaId(Long ideaId);

    /**
     * 手动触发获取审核状态
     *
     * @param ideaId
     */
    void manualObtianAuditStatus(Long ideaId);

    void deleteById(Long id) throws BizException;

    /**
     * 获取adx广告位id
     *
     * @return
     */
    List<Long> selelctAdxSlotIds();

    /**
     * 根据switchStatus查询创意
     *
     * @param switchStatus switchStatus
     * @return list
     */
    List<ResourceIdeaDto> queryAllIdeaBySwitchStatus(Integer switchStatus);

    /**
     * 根据创意Id查询审核记录
     *
     * @param ideaId
     * @return
     */
    List<ResourceIdeaThreeRsp> queryForResourceIdeaAuditList(Long ideaId);

    /**
     * 根据条件查询创意集合
     *
     * @param req
     * @return
     */
    List<Long> selectIds(ResourceIdeaPageReq req);

    /**
     * 根据创意ID查询创意详情（不会关联其他表数据）
     *
     * @param ideaId
     * @return
     */
    ResourceIdeaDto queryIdeaById(Long ideaId);

    /**
     * 根据创意Id查询创意(组合返回图片和推广组信息)
     * @param ideaId
     * @return
     */
    ResourceIdeaDto getIdeaWithPictureAndGroup(Long ideaId);

    /**
     * 查询可用的算法出价的创意
     *
     * @return list
     */
    List<ResourceIdeaDto> queryAlgoIdeaBySwitchStatus();
}
