package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.req.adx.AdxBidReq;
import cn.com.duiba.tuia.activity.center.api.req.adx.MoJiAdxBidReq;

import java.util.List;

/**
 * 猎豹ADX竞价服务
 *
 * @author weny.cai
 * @date 2018/12/6 14:54
 **/
@AdvancedFeignClient
public interface RemoteAdxBidService {

    /**
     * 竞价
     * @param tagId
     * @return
     * @author weny.cai
     * @date 2018/12/6 15:43
     */
    ResourceIdeaDto bid(String tagId);

    /**
     * 竞价
     * @param adxBidReq
     * @return 
     * @author weny.cai
     * @date 2018/12/6 15:43 
     */
    ResourceIdeaDto bidByReq(AdxBidReq adxBidReq);



    /**
     * 获取资源位下所有预算范围里的创意列表
     * @param sourceId
     * @return
     */
    List<ResourceIdeaDto> findValidIdeas(Long sourceId);

    /**
     * 判断tagId对应的资源位当前是否可投
     * @param tagId
     * @return
     */
    boolean validResourcePutable(String tagId);

    /**
     * 墨迹天气
     * 竞价接口
     * @param req
     * @return
     */
    ResourceIdeaDto mojiBid(MoJiAdxBidReq req);
}
