package cn.com.duiba.tuia.activity.center.api.dto.commercial.mission;

import cn.com.duiba.tuia.activity.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.user.BizActivityUserDto;

import java.io.Serializable;

/**
 * [商业化活动]任务条件检查参数
 *
 * @author zhangbaiqiang
 * @date 2019-03-13
 */
public class MissionVerifyReq implements Serializable {
    private static final long serialVersionUID = 8717150118001394110L;

    /**
     * 用户参数
     */
    private CommercialUserReq userReq;

    /**
     * 活动用户信息
     */
    private BizActivityUserDto activityUserDto;

    /**
     * [种红包]当日种红包次数
     */
    private Integer curPlantTimes;

    /**
     * [种红包]当日收红包次数
     */
    private Integer curPickTimes;

    public CommercialUserReq getUserReq() {
        return userReq;
    }

    public MissionVerifyReq setUserReq(CommercialUserReq userReq) {
        this.userReq = userReq;
        return this;
    }

    public BizActivityUserDto getActivityUserDto() {
        return activityUserDto;
    }

    public MissionVerifyReq setActivityUserDto(BizActivityUserDto activityUserDto) {
        this.activityUserDto = activityUserDto;
        return this;
    }

    public Integer getCurPlantTimes() {
        return curPlantTimes;
    }

    public MissionVerifyReq setCurPlantTimes(Integer curPlantTimes) {
        this.curPlantTimes = curPlantTimes;
        return this;
    }

    public Integer getCurPickTimes() {
        return curPickTimes;
    }

    public MissionVerifyReq setCurPickTimes(Integer curPickTimes) {
        this.curPickTimes = curPickTimes;
        return this;
    }
}
