package cn.com.duiba.tuia.activity.center.api.constant.commercial.plant;

import cn.com.duiba.tuia.activity.center.api.dto.commercial.plant.PlantSeedDto;
import org.apache.commons.lang3.RandomUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * [商业化活动]种红包种子类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/08
 */
public enum SeedType {

    TOMATO(1, 14, "西红柿"),
    CORN(2, 3, "玉米"),
    PUMPKIN(3, 2, "南瓜"),
    PITAYA(4, 1, "火龙果"),
    IPHONE(5, 0, "iPhone红包"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 权重
     */
    private Integer weight;

    /**
     * 描述
     */
    private String  desc;

    SeedType(Integer type, Integer weight, String desc) {
        this.type = type;
        this.weight = weight;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public Integer getWeight() {
        return weight;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算种子的成熟时间
     *
     * @param times 当天第几次种
     * @return 成熟时间(秒)
     */
    public int countMatureTime(int times) {
        int matureTime = 0;

//        switch (this) {
//            case TOMATO:
//                if (times <= 3) {
//                    matureTime = RandomUtils.nextInt(2, 4);
//                } else if (times <= 6) {
//                    matureTime = RandomUtils.nextInt(5, 11);
//                } else if (times <= 10) {
//                    matureTime = RandomUtils.nextInt(60, 601);
//                } else {
//                    matureTime = RandomUtils.nextInt(43200, 54001);
//                }
//                break;
//            case CORN:
//                if (times <= 1) {
//                    matureTime = RandomUtils.nextInt(5, 11);
//                } else {
//                    matureTime = RandomUtils.nextInt(60, 601);
//                }
//                break;
//            case PUMPKIN:
//                if (times <= 1) {
//                    matureTime = RandomUtils.nextInt(10, 16);
//                } else {
//                    matureTime = RandomUtils.nextInt(3600, 7201);
//                }
//                break;
//            case PITAYA:
//                matureTime = RandomUtils.nextInt(3600, 7201);
//                break;
//            case IPHONE:
//            default:
//                break;
//        }
        return matureTime;
    }

    /**
     * 获取种子的枚举
     *
     * @param type 种子类型
     * @return 枚举
     */
    public static SeedType valueOf(Integer type) {
        for (SeedType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 枚举转Dto
     */
    public PlantSeedDto toDto() {
        PlantSeedDto seedDto = new PlantSeedDto();
        seedDto.setSeedType(this.getType());
        seedDto.setUnlock(false);
        seedDto.setStock(this.getWeight()); //TODO zbq
        return seedDto;
    }
}
