package cn.com.duiba.tuia.activity.center.api.remoteservice.commercial.dig;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.dig.DigClickReq;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.dig.DigConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.dig.DigDto;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.mission.MissionConfigDto;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDigService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 用户信息  签到信息
     */
    DigDto sign(CommercialUserReq req) throws ActivityCenterException;


    /**
     * 挖矿点击
     *
     * @param req      用户参数
     * @return 用户信息、任务信息，奖励信息
     */
    DigDto dig(DigClickReq req) throws ActivityCenterException;



    /**
     * 挖矿点击
     * @param
     * @return 用户信息、任务信息，奖励信息
     */
    boolean updateDigNodePrizeConfig(Long appId, String configVersion, DigConfigDto configDto);


    /**
     *
     * @param req
     * @param missionId
     * @return
     * @throws BizException
     */
    DigDto finishMission(CommercialUserReq req, String missionId) throws ActivityCenterException;


    List<ArrayList<Integer>> getTreasureList(CommercialUserReq req) throws ActivityCenterException;


    /**
     * 更新任务配置
     * @param appId
     * @param configDto
     * @return
     */
    boolean updatePlantMissionConfig(Long appId, MissionConfigDto configDto);
    
}
