/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.commercial.dig;

import cn.com.duiba.tuia.activity.center.api.constant.commercial.dig.TreasurePrizeType;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;

public enum NodePrizeType {
    GODS_LIGHT(1, "\u795e\u706f"),
    TREASURE_BOX(2, "\u5b9d\u7bb1"),
    CASH_RED_WALLET(3, "\u73b0\u91d1\u7ea2\u5305"),
    HIDDEN_TREASURE_CAVE(4, "\u85cf\u5b9d\u6d1e"),
    GOLD_ORE(5, "\u91d1\u77ff\u77f3"),
    ANCIENT_COIN(6, "\u53e4\u4ee3\u94b1\u5e01"),
    ANCIENT_SHOVEL(7, "\u4e0a\u53e4\u94f2\u5b50"),
    LOST_GRAIL(8, "\u9057\u5931\u7684\u5723\u676f"),
    EXTRATERRESTRIAL_INTELLIGENCE_STONE(9, "\u5916\u661f\u4eba\u77f3\u7891"),
    ANCIENT_PETRIFACTION(10, "\u8fdc\u53e4\u5316\u77f3");

    private Integer code;
    private String desc;

    private NodePrizeType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getDescByCode(Integer code) {
        for (NodePrizeType type : NodePrizeType.values()) {
            if (!Objects.equals(code, type.getCode())) continue;
            return type.getDesc();
        }
        return null;
    }

    public static NodePrizeType getRandomPrize(Integer treasureBox, Integer godsLight) {
        int random = RandomUtils.nextInt((int)1, (int)10001);
        return random <= treasureBox ? TREASURE_BOX : (random <= treasureBox + godsLight ? GODS_LIGHT : CASH_RED_WALLET);
    }

    public static NodePrizeType getEnumByCode(Integer type) {
        for (NodePrizeType nodePrizeType : NodePrizeType.values()) {
            if (!Objects.equals(type, nodePrizeType.getCode())) continue;
            return nodePrizeType;
        }
        return null;
    }

    public static Integer getCashPercent(Integer code) {
        if (code == null) {
            return null;
        }
        int random = RandomUtils.nextInt((int)1, (int)101);
        NodePrizeType nodePrizeType = NodePrizeType.getEnumByCode(code);
        switch (nodePrizeType) {
            case GODS_LIGHT: {
                return 50;
            }
            case TREASURE_BOX: {
                return 50;
            }
            case CASH_RED_WALLET: 
            case HIDDEN_TREASURE_CAVE: 
            case GOLD_ORE: 
            case ANCIENT_COIN: 
            case ANCIENT_SHOVEL: 
            case LOST_GRAIL: 
            case EXTRATERRESTRIAL_INTELLIGENCE_STONE: 
            case ANCIENT_PETRIFACTION: {
                return 100;
            }
        }
        return null;
    }

    public static Integer getRandomCash(Integer code) {
        int random = RandomUtils.nextInt((int)1, (int)101);
        NodePrizeType nodePrizeType = NodePrizeType.getEnumByCode(code);
        switch (nodePrizeType) {
            case GODS_LIGHT: {
                return random <= 50 ? TreasurePrizeType.CASH.getCode() : TreasurePrizeType.TICKET.getCode();
            }
            case TREASURE_BOX: {
                return random <= 30 ? TreasurePrizeType.CASH.getCode() : TreasurePrizeType.TICKET.getCode();
            }
            case CASH_RED_WALLET: 
            case HIDDEN_TREASURE_CAVE: 
            case GOLD_ORE: 
            case ANCIENT_COIN: 
            case ANCIENT_SHOVEL: 
            case LOST_GRAIL: 
            case EXTRATERRESTRIAL_INTELLIGENCE_STONE: 
            case ANCIENT_PETRIFACTION: {
                return TreasurePrizeType.CASH.getCode();
            }
        }
        return null;
    }

    public static boolean isIllustrateHandbook(Integer code) {
        NodePrizeType nodePrizeType = NodePrizeType.getEnumByCode(code);
        switch (nodePrizeType) {
            case GOLD_ORE: 
            case ANCIENT_COIN: 
            case ANCIENT_SHOVEL: 
            case LOST_GRAIL: 
            case EXTRATERRESTRIAL_INTELLIGENCE_STONE: 
            case ANCIENT_PETRIFACTION: {
                return true;
            }
        }
        return false;
    }
}

