package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 小米adx网络类型
 * @Author chensong
 * @Create 2019-03-28
 */
public enum XiaoMiConnetType {

    UNKNOWN(0, "未知", ConnetType.UNKNOW),

    INNET(1,"以太网", ConnetType.INNET),

    WIFI(2,"wifi", ConnetType.WIFI),

    CELLULAR(3, "蜂窝网络-未知", ConnetType.UNKNOW),

    G2(4,"2G", ConnetType.G2),

    G3(5,"3G", ConnetType.G3),

    G4(6,"4G", ConnetType.G4);


    private int type;

    private String desc;

    private ConnetType commonType;


    private XiaoMiConnetType(int type, String desc, ConnetType commonType) {
        this.type = type;
        this.desc = desc;
        this.commonType = commonType;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public ConnetType getCommonType() {
        return commonType;
    }


    public static XiaoMiConnetType getByType(Integer type) {
        return Objects.isNull(type)
                ? UNKNOWN
                : Stream.of(XiaoMiConnetType.values())
                .filter(item -> Objects.equals(item.getType(), type))
                        .findFirst().orElse(UNKNOWN);
    }

}
