package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Objects;

/**
 * [商业化活动]任务类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/12
 */
public enum MissionCycleType {

    DAY(1, "DAY", "每天循环"),
    SERIES(2, "SERIES", "串联任务"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    MissionCycleType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取任务循环类型的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static MissionCycleType getByKey(String key) {
        for (MissionCycleType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }
}
