/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollectionTool {
    public static <E1, E2, P> List<E1> getContainsList(Collection<E1> coll1, Function<E1, P> coll1Func, Collection<E2> coll2, Function<E2, P> coll2Func) {
        if (coll1 == null || coll2 == null || coll1.isEmpty() || coll2.isEmpty()) {
            return Collections.emptyList();
        }
        Map collMap = coll2.stream().collect(Collectors.toMap(coll2Func, Function.identity()));
        return coll1.stream().filter(e -> collMap.containsKey(coll1Func.apply(e))).collect(Collectors.toList());
    }

    public static <E1, E2, P> List<E1> getContainsList(Collection<E1> coll1, Function<E1, P> coll1Func, Map<P, E2> map) {
        if (coll1 == null || map == null || coll1.isEmpty() || map.isEmpty()) {
            return Collections.emptyList();
        }
        return coll1.stream().filter(e -> map.containsKey(coll1Func.apply(e))).collect(Collectors.toList());
    }

    public static <E1, E2, P> List<E1> getContainsList(Map<P, E1> map, Collection<E2> coll2, Function<E2, P> coll2Func) {
        if (map == null || coll2 == null || map.isEmpty() || coll2.isEmpty()) {
            return Collections.emptyList();
        }
        return coll2.stream().filter(e2 -> map.containsKey(coll2Func.apply(e2))).map(e2 -> map.get(coll2Func.apply(e2))).collect(Collectors.toList());
    }

    public static boolean containsStringAny(Collection coll1, Collection coll2) {
        if (coll1 == null || coll1.isEmpty() || coll2 == null || coll2.isEmpty()) {
            return false;
        }
        for (Object o : coll1) {
            Iterator it2 = coll2.iterator();
            while (it2.hasNext()) {
                if (!String.valueOf(o).equals(String.valueOf(it2.next()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

