package cn.com.duiba.tuia.activity.center.api.common;

import cn.com.duiba.tuia.activity.center.api.dto.ActivitySkinDataDto;

import java.io.Serializable;
import java.util.Collection;

/**
 * ClassName: BaseDto <br/>
 * Function: Dto基础类. <br/>
 * Reason: 封装公用逻辑. <br/>
 * date: 2017年2月23日 下午7:13:33 <br/>
 *
 * @author wubo
 * @version 
 */
public class BaseDto implements Serializable{

    private static final long serialVersionUID = 1L;

    private boolean isEmpty = false;

    public BaseDto() {
        super();
    }

    protected BaseDto(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public boolean isEmpty() {
        return isEmpty;
    }

    /**
     * 空类机制
     *
     * 针对 google cache 无法缓存null的情况(load 返回null会报异常)
     * 当load 结果为null时,返回空类
     * isEmpty = true 表示空类
     * 空类 设计为单例
     * 空类 实例化不对外开放
     * 样例：
     * @see ActivitySkinDataDto
     * 其他dto需要使用空类时,参考样例
     * 统一使用 BseDto.isEmpty(dto) 判断dto 是否为空类
     *
     * @author wubo
     * @param dto dto
     * @return boolean
     */
    public static boolean isEmpty(BaseDto dto) {
        return dto == null || dto.isEmpty();
    }

    public static boolean isEmpty(final Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(final Collection<?> coll) {
        return !isEmpty(coll);
    }
}
