package cn.com.duiba.tuia.activity.center.api.constant.story.tree;

import org.apache.commons.collections.CollectionUtils;

/**
 * [深度互动故事完整性]果树等级枚举
 *
 * @author zhangbaiqiang
 * @date 2019-06-05
 */
public enum TreeLevelEnum {

    LV1(1, 0, 2, "幼苗1"),
    LV2(2, 10, 3, "幼苗2"),
    LV3(3, 30, 4, "成长1"),
    LV4(4, 50, 5, "成长2"),
    LV5(5, 70, 6, "成熟期"),
    LV6(6, 100, 7, "完全体"),
    ;

    /*目前经验值的上限*/
    public static final int MAX_EXP = 100;

    /**
     * 等级
     */
    private Integer level;

    /**
     * 成长值
     */
    private Integer exp;

    /**
     * 可结果实数量
     */
    private Integer fruitAmount;

    /**
     * 果树状态
     */
    private String statusDesc;

    TreeLevelEnum(Integer level, Integer exp, Integer fruitAmount, String statusDesc) {
       this.level = level;
       this.exp = exp;
       this.fruitAmount = fruitAmount;
       this.statusDesc = statusDesc;
    }

    public Integer getLevel() {
        return level;
    }

    public Integer getExp() {
        return exp;
    }

    public Integer getFruitAmount() {
        return fruitAmount;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    /**
     * 计算果树等级
     *
     * @param exp 成长值
     * @return 果树等级
     */
    public static TreeLevelEnum calLevel(int exp) {
        TreeLevelEnum[] levels = TreeLevelEnum.values();
        CollectionUtils.reverseArray(levels);
        for (TreeLevelEnum level : levels) {
            if (exp >= level.getExp()) {
                return level;
            }
        }
        return LV1;
    }
}
