package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StorySpikeCleanSumDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StorySpikeResultDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StoryUserSpikeInitInfoDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.StoryUserSpikePrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.req.StorySpikeConfigItemReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.spike.req.StoryUserSpikeCallBackReq;

import java.util.List;

/**
 * RemoteStorySpikeService
 *
 * @author huangruodan
 * @date 2019/6/4
 */

@AdvancedFeignClient
public interface RemoteStorySpikeService {

    /**
     * 获取用户秒杀初始页面信息
     * @param req 请求参数
     * @return 秒杀信息
     * @throws BizException 业务异常
     */
    StoryUserSpikeInitInfoDto spikeInfoInit(StoryUserReq req) throws BizException;

    /**
     * 用户秒杀
     * @param req 请求参数(媒体信息，设备信息)
     * @param itemId 秒杀itemId
     * @return 是否扣除库存成功
     * @throws BizException 业务异常
     */
    StorySpikeResultDto userSpike(StoryUserReq req, Long itemId) throws BizException;

    /**
     * 秒杀中奖和已经抽奖中现金红包的用户列表
     * @param req 请求参数(媒体信息，设备信息)
     * @return 中奖名单
     * @throws BizException 业务异常
     */
    List<StoryUserSpikePrizeDto> getPrizeList(StoryUserReq req) throws BizException;

    /**
     * 秒杀抽奖订单回调
     * @param req 参数(用户数据,订单id,秒杀记录id)
     * @throws BizException 业务异常
     * @return 是否成功
     */
    Boolean spikeOrderCallBack(StoryUserSpikeCallBackReq req) throws BizException;

    /**
     * 保存或更新秒杀配置信息
     * @param detail 请求参数
     * @return 是否保存成功
     * @throws BizException 业务异常
     */
    Boolean saveSpikeConfigItem(StorySpikeConfigItemReq detail) throws BizException;


    /**
     * 清空配置信息
     * @param slotId 广告位id
     * @param creator 操作者id
     * @param creatorName 操作者姓名
     * @return 各个货币的兑换数量
     * @throws BizException 业务异常
     */
    List<StorySpikeCleanSumDto> cleanSpikeConfig(Long slotId, Long creator, String creatorName) throws BizException;


}
