package cn.com.duiba.tuia.activity.center.api.remoteservice.story;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.story.StoryUserReq;
import cn.com.duiba.tuia.activity.center.api.dto.story.tree.TreeAlbumDetailDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.tree.TreeDto;
import cn.com.duiba.tuia.activity.center.api.dto.story.tree.finance.TreeRewardDto;

/**
 * RemoteStoryTreeService
 *
 * @author huangruodan
 * @date 2019/6/6
 */
@AdvancedFeignClient
public interface RemoteStoryTreeService {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 用户信息、土地信息、种子仓库、签到信息
     */
    TreeDto sign(StoryUserReq req) throws BizException;

    /**
     * 种果实
     *
     * @param req    用户参数
     * @return 用户信息，奖励信息
     */
    TreeDto plant(StoryUserReq req) throws BizException;

    /**
     * 收果实
     *
     * @param req    用户参数
     * @param fruitId 种子编号
     * @return 用户信息，奖励信息
     */
    TreeDto pick(StoryUserReq req, Long fruitId) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req       用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    TreeDto finishMission(StoryUserReq req, String missionId) throws BizException;

    /**
     * 种一棵树
     *
     * @param req 用户参数
     * @param treeType 果树类型
     * @return 用户信息
     */
    TreeDto plantTree(StoryUserReq req, Integer treeType) throws BizException;

    /**
     * 果树图鉴
     * @param req 用户参数
     * @return 果树图鉴
     * @throws BizException 业务异常
     */
    TreeAlbumDetailDto getTreeAlbumDetail(StoryUserReq req) throws BizException;

    /**
     * 用户互动游戏
     * @param req 用户请求参数
     * @return 奖励类型
     * @throws BizException 业务异常
     */
    TreeRewardDto userInteractiveReward(StoryUserReq req) throws BizException;
}
