package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 创意样式规格枚举
 * 样式规格,0=默认规格,3=左文右图,5=上文下图,6=上文下3图,7=纯图,8=图文,9=左图右文,10=双图,11=双icon
 * @Author chensong
 * @Create 2019-04-12
 */
public enum IdeaStyleStandardEnum {

    /** 墨迹使用 start **/
    ISS_0000(0, "默认规格"),
    ISS_0003(3, "左文右图"),
    ISS_0005(5, "上文下图"),
    ISS_0006(6, "上文下3图"),
    ISS_0007(7, "纯图"),
    ISS_0008(8, "图文"),
    ISS_0009(9, "左图右文"),
    ISS_0010(10, "双图"),
    ISS_0011(11, "双icon"),
    /** 墨迹使用 end **/

    /** 小米使用 start **/
    ISS_0012(12, "小图"),
    ISS_0013(13, "组图"),
    ISS_0014(14, "大图")
    /** 小米使用 end **/
    ;

    private int value;

    private String desc;

    IdeaStyleStandardEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static IdeaStyleStandardEnum getByValue(Integer value) {
        return Objects.isNull(value)
                ? null
                : Stream.of(IdeaStyleStandardEnum.values())
                        .filter(item -> Objects.equals(item.getValue(), value))
                        .findFirst().orElse(null);
    }
}
