package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Objects;

/**
 * [商业化活动]任务条件类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionConditionType {

    LOGIN(1, "LOGIN", "登录"),
    PLANT(2, "PLANT", "种红包"),
    PICK(3, "PICK", "收红包"),
    CONTINUOUS_LOGIN(4, "CONTINUOUS_LOGIN", "连续登录"),
    DIG(5, "DIG", "挖"),
    ENTER_MINE_CAVE(6, "ENTER_MINE_CAVE", "进入矿洞"),
    OPEN_TREASURE_BOX(7, "OPEN_TREASURE_BOX", "开启宝箱"),
    RETURN_LANDING_PAGE(8, "RETURN_LANDING_PAGE", "直接返回落地页连接"),
    HEAVENLY_TREASURE_CHEST(12, "HEAVENLY_TREASURE_CHEST", "天降宝箱"),
    ;

    /**
     * 类型remoteMissionService
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    MissionConditionType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static MissionConditionType getByKey(String key) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }
}
