package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Objects;

/**
 * [商业化活动]任务奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionPrizeType {

    CASH(1, "CASH", "现金"),
    LAND_UNLOCK(2, "LAND_UNLOCK", "解锁土地"),
    CORN_UNLOCK(3, "CORN_UNLOCK", "解锁玉米"),
    PUMPKIN_UNLOCK(4, "PUMPKIN_UNLOCK", "解锁南瓜"),
    PITAYA_UNLOCK(5, "PITAYA_UNLOCK", "解锁火龙果"),
    BLOCK(6, "BLOCK", "触发区块"),
    ENCOURAGE(7, "ENCOURAGE", "触发增值广告"),
    VIDEO(8, "VIDEO", "视频激励广告"),
    FIRST_PRIZE(9, "FIRST_PRIZE", "新手红包"),
    CASH_LANDING_SHOW(10, "CASH_LANDING_SHOW", "落地页现金奖励"),
    CASH_LANDING_DOWNLOAD(11, "CASH_LANDING_DOWNLOAD", "落地页现金奖励"),
    HEAVENLY_TREASURE_CHEST(12, "HEAVENLY_TREASURE_CHEST", "天降宝箱"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    MissionPrizeType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static MissionPrizeType getByKey(String key) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }
}
