package cn.com.duiba.tuia.activity.center.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.reward.OrderReq;
import cn.com.duiba.tuia.activity.center.api.dto.reward.OrderRsp;
import cn.com.duiba.tuia.activity.center.api.dto.reward.ReportReq;
import cn.com.duiba.tuia.activity.center.api.dto.reward.RewardedNotifyConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.reward.config.RewardedVideoNotifyConfig;

/**
 * 激励视频广告Remote服务接口
 *
 * @author zhangbaiqiang
 * @date 2019-07-10
 */
@AdvancedFeignClient
public interface RemoteRewardedVideoService {

    /**
     * 创建订单并上报
     *
     * @param req 订单请求参数
     * @return 订单信息
     */
    OrderRsp createOrderAndReport(OrderReq req);

    /**
     * 创建激励视频订单（createOrderAndReport 拆分）
     *
     * @param req 订单请求参数
     * @return 订单信息
     */
    OrderRsp createOrder(OrderReq req);

    /**
     * 激励视频奖励上报（createOrderAndReport 拆分）
     */
    void rewardReport(ReportReq req);

    /**
     * 更新上报配置接口
     * @param notifyConfigDto 配置信息
     * @return
     */
    Boolean updateNotifyConfig(RewardedNotifyConfigDto notifyConfigDto);
}
