package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 创意投放方式，0:依次投放,1:按比例投放
 *
 * @author hillchen
 * @create 2019/2/24 14:38
 */
public enum PutType {
    ORDER(0,"依次投放"),
    PROPORTION(1,"按比例投放");

    private int type;
    private String desc;

    PutType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer type){
        return type != null && Objects.equals(type,this.type);
    }

    public static boolean hasPutType(Integer type){
        if(type != null){
            for(PutType priceType : PutType.values()){
                if(priceType.isSameType(type)){
                    return true;
                }
            }
        }
        return false;
    }
}
