package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * OPPO 广告位类型枚举
 *
 * @author lixin
 * @date 2019/9/12 10:52
 **/
public enum OppoSpecEnum {

    /** 信息流 */
    OPPO_001("001", "信息流", 30, "1", "信息流大图",
            Arrays.asList(640), Arrays.asList(320), 1, 50, "JPG/JPEG/PNG", 22, 8),

    /** 横幅 */
    OPPO_002("002", "横幅", 31, "10", "图片",
            Arrays.asList(640), Arrays.asList(100), 1, 30, "JPG/JPEG/PNG", null, null),

    /** 插屏 */
    OPPO_003("003", "插屏", 32, "11", "图片",
            Arrays.asList(600), Arrays.asList(500), 1, 80, "JPG/JPEG/PNG", null, null),

    /** 原生资源 */
    OPPO_004("004", "原生资源", 33, "28", "大图",
            Arrays.asList(640), Arrays.asList(320), 1, 80, "JPG/JPEG/PNG", 14, 8),

    /** 横屏开屏 */
    OPPO_005("005", "开屏", 34, "26", "横屏开屏",
            Arrays.asList(2340), Arrays.asList(1080), 1, 300, "JPG/JPEG/PNG", null, null),

    /** 竖屏开屏 */
    OPPO_006("005", "开屏", 35, "27", "竖屏开屏",
            Arrays.asList(1080, 1080, 1080), Arrays.asList(1512, 1752, 1872), 3, 300, "JPG/JPEG/PNG", null, null);

    /** 广告类型编码 */
    private String specCode;

    /** dsp侧广告类型名称 */
    private String name;

    /** 规格样式 */
    private Integer styleStandard;

    /** 广告样式 */
    private String template;

    /** 广告样式描述 */
    private String templateDescription;

    /** 素材宽度（该字段的值个数和picNum一致，且有顺序保证） */
    private List<Integer> picW;

    /** 素材高度（该字段的值个数和picNum一致，且有顺序保证） */
    private List<Integer> picH;

    /** 素材个数 */
    private Integer picNum;

    /** 素材大小 */
    private Integer size;

    /** 素材格式 */
    private String picType;

    /** 标题限制字数 */
    private Integer titleLimit;

    /** 品牌名称限制字数 */
    private Integer contentLimit;

    /**
     * 构造
     *
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param picNum
     * @param size
     * @param picType
     * @param titleLimit
     */
    OppoSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription, List<Integer> picW, List<Integer> picH, Integer picNum, Integer size, String picType, Integer titleLimit, Integer contentLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
    }

    /**
     * 根据styleStandard查询规则信息
     *
     * @param styleStandard
     * @return
     */
    public static OppoSpecEnum getSpecEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }
        for (OppoSpecEnum specEnum : OppoSpecEnum.values()) {
            if (Objects.equals(specEnum.getStyleStandard(), styleStandard)) {
                return specEnum;
            }
        }
        return null;
    }

    public String getSpecCode() {
        return specCode;
    }

    public void setSpecCode(String specCode) {
        this.specCode = specCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    public List<Integer> getPicW() {
        return picW;
    }

    public void setPicW(List<Integer> picW) {
        this.picW = picW;
    }

    public List<Integer> getPicH() {
        return picH;
    }

    public void setPicH(List<Integer> picH) {
        this.picH = picH;
    }

    public Integer getPicNum() {
        return picNum;
    }

    public void setPicNum(Integer picNum) {
        this.picNum = picNum;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getPicType() {
        return picType;
    }

    public void setPicType(String picType) {
        this.picType = picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public void setTitleLimit(Integer titleLimit) {
        this.titleLimit = titleLimit;
    }

    public Integer getContentLimit() {
        return contentLimit;
    }

    public void setContentLimit(Integer contentLimit) {
        this.contentLimit = contentLimit;
    }
}
