package cn.com.duiba.tuia.activity.center.api.remoteservice.commercial.mission;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.commercial.mission.MissionConfigDto;

/**
 * [商业化活动]任务Remote接口
 *
 * @author zhangbaiqiang
 * @date 2019-03-08
 */
@AdvancedFeignClient
public interface RemoteMissionService {

    /**
     * 根据版本获取任务配置
     *
     * @param configVersion 配置版本
     * @return 任务配置
     */
    MissionConfigDto queryMissionConfig(String configVersion) throws BizException;

    /**
     * 更新任务配置参数(慎用)
     *
     * @param configVersion 配置版本
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updateMissionConfig(String configVersion, MissionConfigDto configDto);
}
