package cn.com.duiba.tuia.activity.usercenter.api.constant;

import java.util.Objects;

/**
 * 提现单状态
 * Created by xuefeng on 2018/6/11.
 */
public enum CashOrderStatus {

    APPLYING(0, "申请中"),
    APPROVE(1, "通过"),
    REFUSE(2, "拒绝"),
    REJECT(3, "驳回");

    private Integer status;
    private String desc;

    CashOrderStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;

    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByStatus(Integer status) {
        for (CashOrderStatus cashOrderStatus : CashOrderStatus.values()) {
            if (Objects.equals(cashOrderStatus.getStatus(), status)) {
                return cashOrderStatus.getDesc();
            }
        }
        return "未知";
    }
}

