package cn.com.duiba.tuia.activity.usercenter.api.constant;

import java.util.Objects;

/**
 * 提现方式
 * Created by xuefeng on 2018/6/12.
 */
public enum CashMode {
    ALIPAY(0, "支付宝");

    private Integer type;
    private String desc;

    CashMode(Integer type, String desc) {
        this.type = type;
        this.desc = desc;

    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type) {
        for (CashMode cashMode : CashMode.values()) {
            if (Objects.equals(cashMode.getType(), type)) {
                return cashMode.getDesc();
            }
        }
        return "未知";
    }
}
