package cn.com.duiba.tuia.activity.usercenter.api.dto.consumer;

import cn.com.duiba.tuia.activity.usercenter.api.constant.SlotLoginType;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by youhaijun on 2017/12/11.
 */
public class ConsumerDto implements Serializable {
    private static final long serialVersionUID = -4732911910049657570L;
    /**
     *
     */
    private Long id;

    /**
     * 用户ID，发号器产生
     */
    private Long userId;

    /**
     * AppID
     */
    private Long appId;

    /**
     * 设备ID
     */
    private String deviceId;

    /**
     * media user ID
     */
    private String muId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 用户密码
     */
    private String password;

    /**
     * 初始密码
     */
    private String initialPassword;

    private ExtInfo extInfo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 最后登陆更新时间
     */
    private Date gmtModified;

    private boolean isNew;

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public ConsumerDto(){}

    public ConsumerDto(Long appId, String deviceId) {
        this.appId = appId;
        this.deviceId = deviceId;
    }

    public void setLogin(SlotLoginType loginType){
        if(this.extInfo == null){
            extInfo = new ExtInfo();
        }
        extInfo.setLoginType(loginType.getType());
    }

    public static class ExtInfo implements Serializable{
        private static final long serialVersionUID = 7875451647347265047L;
        /**性别
         *@see cn.com.duiba.tuia.activity.usercenter.api.constant.SexType
         */
        private Integer sex;
        /**
         * 昵称
         */
        private String nickName;
        /**
         * 头像
         */
        private String img;
        /**登录类型
         *@see SlotLoginType
         */
        private Integer loginType;

        /** 操作系统 Android,ios */
        private String os;

        /** 版本号 */
        private String version;

        /** 渠道 */
        private String channel;

        /** 登录次数，每天登录计1次 */
        private Long loginNum;

        /** 上次登陆时间，每天只记录一次*/
        private Long lastLoginTime;

        public Long getLastLoginTime() {
            return lastLoginTime;
        }

        public void setLastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
        }

        public Long getLoginNum() {
            return loginNum;
        }

        public void setLoginNum(Long loginNum) {
            this.loginNum = loginNum;
        }

        /**
         * 友推的用户标记
         */
        private Integer mark;

        public Integer getSex() {
            return sex;
        }

        public void setSex(Integer sex) {
            this.sex = sex;
        }

        public String getNickName() {
            return nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getImg() {
            return img;
        }

        public void setImg(String img) {
            this.img = img;
        }

        public Integer getLoginType() {
            return loginType;
        }

        public void setLoginType(Integer loginType) {
            this.loginType = loginType;
        }

        public String getOs() {
            return os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public Integer getMark() {
            return mark;
        }

        public void setMark(Integer mark) {
            this.mark = mark;
        }
    }

    public ConsumerCache toConsumerCache() {
        ConsumerCache consumerCache = new ConsumerCache();
        consumerCache.setAppId(this.getAppId());
        consumerCache.setSex(this.getExtInfo().getSex());
        consumerCache.setUserId(this.getUserId());
        consumerCache.setGmtCreate(this.getGmtCreate());
        if (this.getExtInfo() != null) {
            consumerCache.setSex(this.getExtInfo().getSex());
            consumerCache.setNickName(this.getExtInfo().getNickName());
            consumerCache.setImg(this.getExtInfo().getImg());
            consumerCache.setLoginType(this.getExtInfo().getLoginType());
        }
        return consumerCache;
    }

    public ExtInfo getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(ExtInfo extInfo) {
        this.extInfo = extInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getMuId() {
        return muId;
    }

    public void setMuId(String muId) {
        this.muId = muId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getInitialPassword() {
        return initialPassword;
    }

    public void setInitialPassword(String initialPassword) {
        this.initialPassword = initialPassword;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }


    @Override
    public String toString(){
        return ToStringBuilder.reflectionToString(this);
    }
}
