package cn.com.duiba.tuia.activity.usercenter.api.dto.req;

import java.io.Serializable;
import java.util.List;

import cn.com.duiba.tuia.activity.usercenter.api.constant.VirtualRechargeType;

public class ReqVirtualRecharge implements Serializable {
	private static final long serialVersionUID = 4782923491776536819L;
	/** 页面收集信息 **/
	//key--文案，value--填写内容，type--文案类型
	private List<VirtualContext> contextArray;
	//媒体标识
	private VirtualRechargeType appFlag;
	private String appKey;
	private String appSecret;
	
	/** 商品信息 **/
	private String virtualAppId;//API充值虚拟商品标识
	private Long virtualId;//虚拟奖品id
	private String title;//奖品标题
	
	/** 订单信息 **/
	private String orderId;//订单号
	private String numRecharge;//数值充值
	
	//用户信息
	private String userId;//第三方用户id

	public ReqVirtualRecharge() {
		super();
	}

	public VirtualRechargeType getAppFlag() {
		return appFlag;
	}

	public void setAppFlag(VirtualRechargeType appFlag) {
		this.appFlag = appFlag;
	}

	public String getVirtualAppId() {
		return virtualAppId;
	}

	public void setVirtualAppId(String virtualAppId) {
		this.virtualAppId = virtualAppId;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public List<VirtualContext> getContextArray() {
		return contextArray;
	}

	public void setContextArray(List<VirtualContext> contextArray) {
		this.contextArray = contextArray;
	}

	public Long getVirtualId() {
		return virtualId;
	}

	public void setVirtualId(Long virtualId) {
		this.virtualId = virtualId;
	}

	public String getNumRecharge() {
		return numRecharge;
	}

	public void setNumRecharge(String numRecharge) {
		this.numRecharge = numRecharge;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getAccount(){
		if(this.contextArray == null || this.contextArray.isEmpty()){
			return null;
		}
		StringBuilder account = new StringBuilder();
		this.contextArray.forEach(o->account.append(o.getValue()).append(","));
		String result = account.toString();
		return result.substring(0,result.length()-1);
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}
	
}
