package cn.com.duiba.tuia.activity.usercenter.api.constant;

import java.util.Arrays;
import java.util.List;

public enum BalanceRecordType {
    FIRST_LOGIN(1, "首次登录奖励"),

    ACTIVITY(2, "活动奖励"),

    MISSION(3, "任务奖励"),

    SURPRISE(4, "惊喜福利"),

    WITHDRAW(5, "提现"),

    GAME(6,"游戏奖励"),

    GAME_CONSUME(7,"游戏消耗"),
    GAME_DAILY_FIRST(8,"每日首次"),
    CREDITS_CONSUME(9,"积分商城消耗"),
    CREDITS_ROLLBACK(10,"积分商城兑换失败回滚"),
    THIRD_TO_TUIA(11,"第三方积分兑换推啊金币"),
    TUIA_TO_THIRD(12,"推啊金币兑换第三方积分消耗"),
    ;

    private Integer type;
    private String  desc;

    BalanceRecordType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;

    }

    static final List<BalanceRecordType> in = Arrays.asList(FIRST_LOGIN, ACTIVITY, MISSION, SURPRISE, GAME, GAME_DAILY_FIRST, CREDITS_ROLLBACK, THIRD_TO_TUIA);

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    // 1为收入 2为支出
    public static Integer getChangeType(BalanceRecordType balanceRecordType) {
        if (in.contains(balanceRecordType)) {
            return 1;
        } else {
            return 2;
        }
    }

    public static String getDesc(Integer type) {
        for (BalanceRecordType recordType : BalanceRecordType.values()) {
            if (recordType.getType().equals(type)) {
                return recordType.getDesc();
            }
        }
        return null;
    }
}
