package cn.com.duiba.tuia.activity.usercenter.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.usercenter.api.common.PageDto;
import cn.com.duiba.tuia.activity.usercenter.api.constant.BalanceRecordType;
import cn.com.duiba.tuia.activity.usercenter.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.usercenter.api.dto.YoutuiEstimateDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.consumer.BalanceRecordDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.consumer.req.BalanceRecordMove;
import cn.com.duiba.tuia.activity.usercenter.api.dto.consumer.req.BalanceRecordQueryDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.ContentReq;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.UserBalanceDetailReq;
import cn.com.duiba.tuia.activity.usercenter.api.dto.rsp.ContentBalanceRsp;

@AdvancedFeignClient
public interface RemoteBalanceRecordService {

    /**
     * 获取用户的金额变动记录
     * 
     * @param queryDto 查询对象
     * @return 余额记录列表
     */
    List<BalanceRecordDto> list(BalanceRecordQueryDto queryDto);

    /**
     * 统计符合条件的记录数
     * 
     * @param queryDto 查询对象
     * @return 记录数
     */
    Integer count(BalanceRecordQueryDto queryDto);

    /**
     * 财务记录迁移
     * 
     * @param moveRequest 迁移请求
     * @return 迁移结果
     */
    Boolean move(BalanceRecordMove moveRequest);

    /**
     * 上面是现金钱包
     * 此方法定制了部分逻辑，主要是处理游戏首次赠送的钱
     * @param moveRequest 迁移请求
     * @return 迁移结果
     */
    Boolean move2(BalanceRecordMove moveRequest);

    PageDto<BalanceRecordDto> pageList(BalanceRecordQueryDto queryDto);

    /**查询该积分商城对应的订单，提供给回滚使用
     * 优先查询orderId对应的订单是否符合，不符合查询今天所有的遍历得到符合的记录
     * @param orderId 账户变更兑换记录id
     * @param duibaOrderNUm 兑吧积分商城订单id
     * @return
     */
    BalanceRecordDto getCreditsConsumeRecord(Long userId, String orderId, String duibaOrderNUm);

    /**
     * 获取账户每日首次赠送流水
     * @param userId
     * @param balanceId
     * @return
     */
    BalanceRecordDto getFirstLoginRecord(Long userId, Long balanceId, BalanceType balanceType);

    /**
     * 获取友推账户昨日收益
     * @param userId
     * @return
     */
    Long getYoutuiYesterdatIncome(Long userId);

    /**
     * 获取今日实时收益 总额
     * @param userId
     * @return
     */
    Long getEstimateAmount(Long userId);

    /**
     * 获取内容的收益
     * @param contentReq
     * @return
     */
    Long getEstimateAmountByContent(ContentReq contentReq);

    /**
     * 获取今日实时收益 列表
     * @param userId
     * @return
     */
    List<YoutuiEstimateDto> getEstimateList(Long userId);

    /**
     * 用户余额明细
     * @param req
     * @return
     */
    List<BalanceRecordDto> getBalanceDetail(UserBalanceDetailReq req);
    /**
     * 根据账户流水类型获得赠送流水
     */
    BalanceRecordDto getFirstLoginRecordByType(Long userId, Long balanceId, BalanceType balanceType,BalanceRecordType balanceRecordType);

    /**
     * 查找用户制定明细的最新记录
     * @param userId
     * @param type
     * @return
     */
    BalanceRecordDto selectNewByRecordType(Long userId, BalanceRecordType type);

    /**
     * 查询用户特定类型的流水记录
     * @param userId
     * @param types
     * @param startTime
     * @param endTime
     * @return
     */
    List<BalanceRecordDto> getRecordByUserIdAndType(Long userId, List<Integer> types, String startTime, String endTime);
}
