package cn.com.duiba.tuia.activity.usercenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.usercenter.api.dto.ContentStaticDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.ContentReq;
import cn.com.duiba.tuia.activity.usercenter.api.dto.rsp.ContentStaticRsp;

import java.util.List;

/**
 * Created by xuefeng on 2018/5/21.
 */
@AdvancedFeignClient
public interface RemoteContentStaticService {

    /**
     * 根据所有内容维度统计数据
     * @return
     */
    List<ContentStaticDto> selectAll();

    /**
     * 根据内容获取内容相关统计数据
     * @param contentReqs
     * @return
     */
    List<ContentStaticRsp> selectListsByContents(List<ContentReq> contentReqs);

    /**
     * 根据内容获取内容相关统计数据
     * @param contentReq
     * @return
     */
    ContentStaticDto selectByContent(ContentReq contentReq);
}
