package cn.com.duiba.tuia.activity.usercenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.usercenter.api.dto.consumer.TuiaConsumerDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.consumer.req.TuiaConsumerReq;
import cn.com.duiba.tuia.activity.usercenter.api.exception.ActivityCenterException;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2019-08-28
 * @description: 推啊用户体系
 **/
@AdvancedFeignClient
public interface RemoteTuiaConsumerService {


    /**
     * 根据deviceId查询用户Id  不存在则创建
     * @param req
     * @return
     */
    Long findOrCreateTuiaUser(TuiaConsumerReq req) throws ActivityCenterException;

    /**
     * 根据deviceId查询用户Id
     * @param req
     * @return
     */
    TuiaConsumerDto findTuiaUser(TuiaConsumerReq req) throws ActivityCenterException;
}
