package cn.com.duiba.tuia.activity.usercenter.api.util;

import cn.com.duiba.tuia.activity.usercenter.api.common.Probability;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Prob<T> {

    private static Random random = new Random();
    private List<Node<T>> list = new ArrayList<>();



    public void put(T t, Probability probability) {
        if (probability != null) {
            list.add(new Node<>(t, probability));
        }
    }

    /**
     * 根据概率百分数的结果返回。
     *
     * 精度支持到1%，如果put的概率小于1%，则会被认为是0
     * 自行保证put的概率之和为100%
     * 如果put的概率之和小于100%，则 1-总概率的部分返回null
     * 如果put的概率之和大于100%，则多余1部分的概率无效
     * @return
     */
    public T getPercentRandom() {
        int rs = random.nextInt(100);// ([0,100)
        for (Node<T> node : list) {
            rs -= node.probability.intPercentValue();
            if (rs < 0) {
                return node.getData();
            }
        }

        return null;
    }




    static class Node<T> {
        T data;
        Probability probability;

        private Node(T data, Probability probability) {
            this.data = data;
            this.probability = probability;
        }

        public final T getData() {
            return data;
        }

        public final Probability getProbability() {
            return probability;
        }
    }
}
