package cn.com.duiba.tuia.activity.usercenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.usercenter.api.common.PageDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.YoutuiCashOrderDto;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.CashOrderAuditReq;
import cn.com.duiba.tuia.activity.usercenter.api.dto.req.CashOrderReq;
import cn.com.duiba.tuia.activity.usercenter.api.dto.rsp.CashOrderRsp;

import java.util.List;

/**
 * 提现相关服务
 * Created by xuefeng on 2018/6/11.
 */
@AdvancedFeignClient
public interface RemoteCashOrderService {

    /**
     * 获取提现列表信息
     * @param cashOrderReq
     * @param offset
     * @param max
     * @return
     */
    PageDto<CashOrderRsp> getList(CashOrderReq cashOrderReq, Integer offset, Integer max);

    /**
     * 审批
     * @param cashOrderAuditReq
     * @return
     */
    Boolean audit(CashOrderAuditReq cashOrderAuditReq);

    /**
     * 根据订单id查询
     * @param orderId
     * @return
     */
    YoutuiCashOrderDto getByOrderId(String orderId);

    /**
     *根据订单ids查询
     * @param orderIds
     * @return
     */
    List<YoutuiCashOrderDto> getByOrderIds(List<String> orderIds);

    /**
     * 获取提现排行榜
     * @return
     */
    List<YoutuiCashOrderDto> getCashRankList(Integer pageSize);

    /**
     * 根据用户id查询最新的一条记录
     * @param userId
     * @return
     */
    YoutuiCashOrderDto getLastByUid(Long userId);

    /**
     * 查询用户最新的订单id
     * @param userId
     * @return
     */
    String getLastOrderId(Long userId);
}
