package cn.com.duiba.tuia.mapper;

import cn.com.duiba.tuia.model.entity.AccountEntity;
import cn.com.duiba.tuia.model.param.AccountParam;

import java.util.List;

/**
 * @author peanut.huang
 * @date 2019/11/11
 * @since JDK 1.8
 */
public interface AccountMapper {

    /**
     * 查询账号
     *
     * @param list
     * @return
     */
    List<AccountEntity> selectByIds(List<Long> list);

    /**
     * 条件查询账号
     *
     * @param param
     * @return
     */
    List<AccountEntity> selectByParam(AccountParam param);

    /**
     * 广告主不能有下级
     *
     * @param userType
     * @return
     */
    List<AccountEntity> selectAdvertiserSubLevelByUserType(Integer userType);

    /**
     * 广告主有且只有一个操作员
     *
     * @return
     */
    List<AccountEntity> selectAdvertiserAndEmployee(AccountParam param);

    /**
     * 管理员、业务员、财务员、操作员，必须要有代理商
     *
     * @return
     */
    List<AccountEntity> selectRoleMustAgent();

}
