package cn.com.duiba.tuia.mapper;

import cn.com.duiba.tuia.model.entity.AdvertEntity;
import cn.com.duiba.tuia.model.param.AdvertParam;

import java.util.List;

/**
 * @author peanut.huang
 * @date 2019/11/11
 * @since JDK 1.8
 */
public interface AdvertMapper {

    /**
     * 条件查询
     * @param param
     * @return
     */
    List<AdvertEntity> selectByParam(AdvertParam param);

    /**
     * 查询广告默认配置的数据
     * @return
     */
    List<AdvertEntity> selectAdvertCountDefPackage();

    /**
     * 查询互动广告默认素材的数量
     * @return
     */
    List<AdvertEntity> selectHdAdvertCountDefMaterial();

    /**
     * 展示广告每个尺寸仅有一个默认素材
     * @return
     */
    List<AdvertEntity> selectShowEveryMustOneMaterial();

    /**
     * 查询广告的资源标签
     * @return
     */
    List<AdvertEntity> selectAdvertCountResourceTag(AdvertParam param);

    /**
     * 查询广告行业标签的数量
     * @return
     */
    List<AdvertEntity> selectAdvertCountTradeTag(AdvertParam param);

    /**
     * 筛选有效的广告ID
     * @param advertIds
     * @return
     */
    List<Long> filterValidAdvertId(List<Long> advertIds);

}
