/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum AppFlowTypeEnum {
    WECHAT("1", "micromessenger", "\u5fae\u4fe1"),
    QQ("2", "qq", "QQ"),
    ALIPAY("3", "alipayclient", "\u652f\u4ed8\u5b9d"),
    OTHER("4", "", "\u5176\u4ed6");

    private String code;
    private String uaFlag;
    private String desc;
    private static Map<String, AppFlowTypeEnum> enumMap;

    private AppFlowTypeEnum(String code, String uaFlag, String desc) {
        this.code = code;
        this.uaFlag = uaFlag;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getUaFlag() {
        return this.uaFlag;
    }

    public String getDesc() {
        return this.desc;
    }

    public static AppFlowTypeEnum getByName(String code) {
        AppFlowTypeEnum appFlowTypeEnum = enumMap.get(code);
        return appFlowTypeEnum == null ? OTHER : appFlowTypeEnum;
    }

    public static AppFlowTypeEnum findByUserAgent(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return OTHER;
        }
        String toLowerCase = userAgent.toLowerCase();
        for (AppFlowTypeEnum item : AppFlowTypeEnum.values()) {
            if (!toLowerCase.contains(item.getUaFlag())) continue;
            return item;
        }
        return OTHER;
    }

    static {
        enumMap = Maps.newHashMap();
        for (AppFlowTypeEnum item : AppFlowTypeEnum.values()) {
            enumMap.put(item.getCode(), item);
        }
    }
}

