package cn.com.duiba.tuia.adx.center.api.code;

import cn.com.duiba.tuia.adx.center.api.constant.AlipayOrderStatus;

public enum BillCode {

    C0000("0000", "提交成功", AlipayOrderStatus.WAIT_CALL_BACK.getStatus()),
    C1001("1001", "参数不完整", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C1002("1002", "手机号不正确", AlipayOrderStatus.CONSUMER_ERROR.getStatus()),
    C1003("1003", "金额不正确", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C1004("1004", "账户不存在", AlipayOrderStatus.CONSUMER_ERROR.getStatus()),
    C1005("1005", "密码不正确", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C1006("1006", "IP鉴权失败", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C1007("1007", "md5 key 验证不正确", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2001("2001", "账户已暂停", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2002("2002", "账户余额异常", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2003("2003", "联通智能网号码(运营商要求，该号码只支持20，30，50，100，300元五个面值)", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2004("2004", "订单号重复", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2005("2005", "余额不足", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C2006("2006", "该产品未开通", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    C9999("9999", "系统错误", AlipayOrderStatus.SYSTEM_ERROR.getStatus()),
    ;

    private String code;
    private String desc;
    private Integer status;

    BillCode(String code, String desc, Integer status) {
        this.code = code;
        this.desc = desc;
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    public Integer getStatus() {
        return status;
    }

    public static BillCode getByCode(String code) {
        for (BillCode bill : BillCode.values()) {
            if (bill.code.equals(code)) {
                return bill;
            }
        }
        return null;
    }
}
