package cn.com.duiba.tuia.adx.center.api.constant;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * ClassName: AppFlowTypeEnum <br/>
 * Function: 流量类型. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public enum AppFlowTypeEnum {

    /** 微信 */
    WECHAT("1", "micromessenger", "微信"),

    /** QQ User-Agent标识辨识度比较差，会产生不精确的结果 */
    QQ("2", "qq","QQ"),

    /** 支付宝 */
    ALIPAY("3", "alipayclient","支付宝"),

    /** 其他 */
    OTHER("4", StringUtils.EMPTY,"其他");

    private String code;

    private String uaFlag;

    private String desc;

    AppFlowTypeEnum(String code, String uaFlag, String desc) {
        this.code = code;
        this.uaFlag = uaFlag;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getUaFlag() {
        return uaFlag;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<String, AppFlowTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AppFlowTypeEnum item : AppFlowTypeEnum.values()) {
            enumMap.put(item.getCode(), item);
        }
    }

    public static AppFlowTypeEnum getByName(String code) {
        AppFlowTypeEnum appFlowTypeEnum = enumMap.get(code);
        return appFlowTypeEnum == null ? AppFlowTypeEnum.OTHER : appFlowTypeEnum;
    }

    public static AppFlowTypeEnum findByUserAgent(String userAgent) {
        if (StringUtils.isBlank(userAgent)) {
            return AppFlowTypeEnum.OTHER;
        }
        String toLowerCase = userAgent.toLowerCase();
        for (AppFlowTypeEnum item : AppFlowTypeEnum.values()) {
            if (toLowerCase.contains(item.getUaFlag())) {
                return item;
            }
        }
        return AppFlowTypeEnum.OTHER;
    }
}