package cn.com.duiba.tuia.adx.center.api.constant.adx;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * ClassName: <br/>
 * Function: adx类型. <br/>
 * Date:  2021/7/30 10:33 上午<br/>
 *
 * @author cuiwx
 * @since JDK 1.6
 */
@Getter
public enum AdxDataTypeEnum {
    POPULAR_GROUP(1, 24L, "推广组"),
    RESOURCE_LOCATION(2, 25L, "资源位"),
    RESOURCE_IDEA(3, 26L, "创意计划"),
    MATERIAL_UNIT(4, 27L, "创意素材"),
    ;

    /**
     * 数据类型
     */
    private Integer dataType;
    /**
     * hologres配置表id
     */
    private Long holoConfigId;
    /**
     * 描述
     */
    private String desc;

    AdxDataTypeEnum(Integer dataType, Long holoConfigId, String desc) {
        this.dataType = dataType;
        this.holoConfigId = holoConfigId;
        this.desc = desc;
    }

    public static AdxDataTypeEnum convertDataType(Integer dataType) {
        return Arrays.stream(AdxDataTypeEnum.values())
                .filter(x -> Objects.equals(x.getDataType(), dataType))
                .findFirst().orElse(null);
    }

}
