package cn.com.duiba.tuia.adx.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created by youhaijun on 2017/6/29.
 */
public class AlipayParam implements Serializable {

    private static final long serialVersionUID = 8009204875516006185L;

    public static final String OUT_BIZ_NO = "out_biz_no";//转账唯一订单号
    public static final String PAYEE_ACCOUNT = "payee_account";//收款方账户
    public static final String AMOUNT = "amount";//转账金额
    public static final String PAYER_SHOW_NAME = "payer_show_name";//媒体名称
    public static final String PAYEE_REAL_NAME = "payee_real_name";//收款方真实姓名

    // 新版API字段
    public static final String TRANS_AMOUNT = "trans_amount";//订单总金额
    public static final String PRODUCT_CODE = "product_code";//转账类型
    public static final String PRODUCT_CODE_TRANS_ACCOUNT_NO_PWD = "TRANS_ACCOUNT_NO_PWD";//单笔无密转账
    public static final String PRODUCT_CODE_STD_RED_PACKET = "STD_RED_PACKET";//现金红包 类型转账

    public static final String ORDER_TITLE = "order_title";//订单标题 用于在支付宝用户的账单里显
    public static final String PAYEE_INFO = "payee_info";//收款方信息
    public static final String IDENTITY = "identity";//参与方的唯一标识
    public static final String IDENTITY_TYPE = "identity_type";//参与方的标识类型，目前支持如下类型：
    public static final String IDENTITY_TYPE_ALIPAY_USER_ID = "ALIPAY_USER_ID";//支付宝的会员ID
    public static final String IDENTITY_TYPE_ALIPAY_LOGON_ID = "ALIPAY_LOGON_ID";//支付宝登录号，支持邮箱和手机号格式
    public static final String NAME = "name";//姓名
    public static final String REMARK = "remark";//备注
    public static final String BUSINESS_PARAMS = "business_params";//扩展
    public static final String BIZ_SCENE = "biz_scene"; //描述特定的业务场景
    public static final String BIZ_SCENE_DIRECT_TRANSFER = "DIRECT_TRANSFER";//单笔无密转账到支付宝，B2C现金红包;


    private Map<String, String> bizContent = new TreeMap<>();

    public Map<String, String> getBizContent() {
        return bizContent;
    }

    public String getJsonString() {
        return JSONObject.toJSONString(bizContent);
    }

    public void setParam(String key, String value) {
        bizContent.put(key, value);
    }

    public String getParam(String key) {
        return bizContent.get(key);
    }
}
