package cn.com.duiba.tuia.adx.center.api.dto.story.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * [深度互动故事完整性]秒杀配置响应
 *
 * @author zhangbaiqiang
 * @date 2019-05-28
 */
public class RspSpikeDto implements Serializable {
    private static final long serialVersionUID = 8021347754767550530L;

    @ApiModelProperty("秒杀开始日期")
    @JsonFormat(timezone = "GMT+8", pattern = "MM月dd日")
    private Date startDate;

    @ApiModelProperty("秒杀结束日期")
    @JsonFormat(timezone = "GMT+8", pattern = "MM月dd日")
    private Date endDate;

    @ApiModelProperty("秒杀开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "HH:mm")
    private Date startTime;

    @ApiModelProperty("消耗金币")
    private Long costCoin;

    @ApiModelProperty("兑换货币单位")
    private Long exchangeCurrency;

    @ApiModelProperty("兑换货币单位")
    private String exchangeCurrencyUnit;

    @ApiModelProperty("库存")
    private Integer exchangeStock;

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Long getCostCoin() {
        return costCoin;
    }

    public void setCostCoin(Long costCoin) {
        this.costCoin = costCoin;
    }

    public Long getExchangeCurrency() {
        return exchangeCurrency;
    }

    public void setExchangeCurrency(Long exchangeCurrency) {
        this.exchangeCurrency = exchangeCurrency;
    }

    public String getExchangeCurrencyUnit() {
        return exchangeCurrencyUnit;
    }

    public void setExchangeCurrencyUnit(String exchangeCurrencyUnit) {
        this.exchangeCurrencyUnit = exchangeCurrencyUnit;
    }

    public Integer getExchangeStock() {
        return exchangeStock;
    }

    public void setExchangeStock(Integer exchangeStock) {
        this.exchangeStock = exchangeStock;
    }
}
