/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.adx.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.center.api.dto.SkinLayerConfigDto;

import java.util.List;

/**
 * 类描述: remote查询各个维度弹层
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-06-26
 * @since 1.0
 */
@AdvancedFeignClient
public interface RemoteSkinLayerConfigService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    SkinLayerConfigDto select(Long id);

    /**
     * 根据业务id和业务类型查询弹层列表
     *
     * @param bizId
     * @param bizType
     * @return
     */
    List<SkinLayerConfigDto> selectList(String bizId, Integer bizType);

    /**
     * group by 分页
     *
     * @param bizType
     * @return
     */
    Integer selectListCount(Integer bizType);

    /**
     * group by 分页
     *
     * @param bizType
     * @param offset
     * @param max
     * @return
     */
    List<SkinLayerConfigDto> selectListPage(Integer bizType, Integer offset, Integer max);

    /**
     * 根据业务id和业务类型查询弹层列表
     *
     * @param bizType
     * @return
     */
    List<SkinLayerConfigDto> selectListAll(Integer bizType);

    /**
     * 查询行业弹层详情
     *
     * @param bizIdList
     * @param bizType
     * @return
     */
    List<SkinLayerConfigDto> selectByBizIdListAndType(List<String> bizIdList, Integer bizType);

    /**
     * 根据业务id和业务类型删除弹层列表
     *
     * @param bizId
     * @param bizType
     * @return
     */
    int deleteList(String bizId, Integer bizType);

    /**
     * 批量写入弹层列表
     *
     * @return
     */
    int insertBatch(List<SkinLayerConfigDto> skinLayerConfigDtoList);

    /**
     * 插入
     *
     * @param skinLayerConfigEntity
     * @return
     */
    int insert(SkinLayerConfigDto skinLayerConfigEntity);

    /**
     * 更新
     *
     * @param skinLayerConfigEntity
     * @return
     */
    int update(SkinLayerConfigDto skinLayerConfigEntity);

}
