/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.adx.center.api.constant;

import cn.com.duiba.tuia.adx.center.api.dto.plant.PlantSeedDto;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;

public enum PlantV2SeedType {
    TOMATO(1, 29, "0~1\u5143"),
    CORN(2, 3, "0~2\u5143\u7ea2\u5305"),
    PUMPKIN(3, 2, "0~3\u5143\u7ea2\u5305"),
    PITAYA(4, 1, "0~5\u5143\u7ea2\u5305"),
    IPHONE(5, 0, "0~iPhone\u7ea2\u5305");

    private Integer type;
    private Integer stock;
    private String desc;

    private PlantV2SeedType(Integer type, Integer stock, String desc) {
        this.type = type;
        this.stock = stock;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getStock() {
        return this.stock;
    }

    public String getDesc() {
        return this.desc;
    }

    public int countMatureTime(int times) {
        int matureTime = 0;
        switch (this) {
            case TOMATO: {
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt((int)2, (int)4);
                    break;
                }
                if (times <= 6) {
                    matureTime = RandomUtils.nextInt((int)5, (int)11);
                    break;
                }
                if (times <= 10) {
                    matureTime = RandomUtils.nextInt((int)60, (int)601);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)43200, (int)54001);
                break;
            }
            case CORN: {
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt((int)5, (int)11);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)60, (int)601);
                break;
            }
            case PUMPKIN: {
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt((int)10, (int)16);
                    break;
                }
                matureTime = RandomUtils.nextInt((int)3600, (int)7201);
                break;
            }
            case PITAYA: {
                matureTime = RandomUtils.nextInt((int)3600, (int)7201);
                break;
            }
        }
        return matureTime;
    }

    public static PlantV2SeedType valueOf(Integer type) {
        for (PlantV2SeedType typeEnum : PlantV2SeedType.values()) {
            if (!Objects.equals(typeEnum.getType(), type)) continue;
            return typeEnum;
        }
        return null;
    }

    public PlantSeedDto toDto() {
        PlantSeedDto seedDto = new PlantSeedDto();
        seedDto.setSeedType(this.getType());
        seedDto.setUnlock(false);
        seedDto.setStock(this.getStock());
        return seedDto;
    }
}

