package cn.com.duiba.tuia.adx.center.api.bean.enums.creative;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * Adx 枚举
 * 注: 标记支持 Adx 类型
 * @dateTime 2019-10-18 15:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum AdxSupportEnum {

    /*################################# 标记 Adx 类型的枚举 ( Start ) #####################################*/

    LianShang(9, "连尚");

    /*################################# 标记 Adx 类型的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    @Setter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    @Setter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static AdxSupportEnum seekValue(Integer code) {
        Optional<AdxSupportEnum> result = Arrays.stream(AdxSupportEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

    /**
     * 是否存在
     * @param code 标识码
     * @return 结果
     */
    @NotNull
    public static Boolean isExist(Integer code) {
        return Objects.nonNull(seekValue(code));
    }

}
