package cn.com.duiba.tuia.adx.center.api.constant;

import cn.com.duiba.tuia.adx.center.api.dto.plant.PlantSeedDto;
import org.apache.commons.lang3.RandomUtils;

import java.util.Objects;

/**
 * [种红包V2]种子类型枚举
 *
 * @author zhangbaiqiang
 * @date 2018/12/17
 */
public enum PlantV2SeedType {

    TOMATO(1, 29, "0~1元"),
    CORN(2, 3, "0~2元红包"),
    PUMPKIN(3, 2, "0~3元红包"),
    PITAYA(4, 1, "0~5元红包"),
    IPHONE(5, 0, "0~iPhone红包"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 当日默认库存
     */
    private Integer stock;

    /**
     * 描述
     */
    private String  desc;

    PlantV2SeedType(Integer type, Integer stock, String desc) {
        this.type = type;
        this.stock = stock;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public Integer getStock() {
        return stock;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算种子的成熟时间
     *
     * @param times 当天第几次种
     * @return 成熟时间(秒)
     */
    public int countMatureTime(int times) {
        int matureTime = 0;

        switch (this) {
            case TOMATO:
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt(2, 4);
                } else if (times <= 6) {
                    matureTime = RandomUtils.nextInt(5, 11);
                } else if (times <= 10) {
                    matureTime = RandomUtils.nextInt(60, 601);
                } else {
                    matureTime = RandomUtils.nextInt(43200, 54001);
                }
                break;
            case CORN:
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt(5, 11);
                } else {
                    matureTime = RandomUtils.nextInt(60, 601);
                }
                break;
            case PUMPKIN:
                if (times <= 1) {
                    matureTime = RandomUtils.nextInt(10, 16);
                } else {
                    matureTime = RandomUtils.nextInt(3600, 7201);
                }
                break;
            case PITAYA:
                matureTime = RandomUtils.nextInt(3600, 7201);
                break;
            case IPHONE:
            default:
                break;
        }
        return matureTime;
    }

    /**
     * 获取种子的枚举
     *
     * @param type 种子类型
     * @return 枚举
     */
    public static PlantV2SeedType valueOf(Integer type) {
        for (PlantV2SeedType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 枚举转Dto
     */
    public PlantSeedDto toDto() {
        PlantSeedDto seedDto = new PlantSeedDto();
        seedDto.setSeedType(this.getType());
        seedDto.setUnlock(false);
        seedDto.setStock(this.getStock());
        return seedDto;
    }
}
