package cn.com.duiba.tuia.adx.center.api.constant;

public enum PluginType {

    COMMON(1, 2001, "普通插件"),
    EMBEDDED(2, 2002, "嵌入式插件"),
    RESPONSIVE(3, 2003, "响应式插件"),
    TIMINGPLUGIN(4, 2004, "定时插件"),
    ;

    private Integer type;

    private Integer activityType;

    /** desc:描述. */
    private String  desc;

    PluginType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    PluginType(Integer type, Integer activityType, String desc) {
        this.type = type;
        this.activityType = activityType;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public String getDesc() {
        return desc;
    }

    public static PluginType getByType(int type) {
        for (PluginType pluginType : PluginType.values()) {
            if (pluginType.getType().equals(type)) {
                return pluginType;
            }
        }
        return null;
    }
    
}
