/**
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.adx.center.api.constant;

/**
 * 描述: 广告位用户对接类型--tb_plug_buoy_config.login_type字段枚举
 *
 * @version v1.0
 * @date 2017/12/12 20:28
 */
public enum SlotLoginType {

    NORMAL(0, "活动普通登录"),//普通活动的免登录逻辑
    PHONE(1, "手机号登录"),//用户采用手机号手动登录
    WEIXIN(2, "微信自动登录"),//微信游戏厅时候deviceId里携带的是用户openId
    MEDIA(3, "媒体用户自动登录");//为媒体用户自登录，会校验请求签名

    private Integer type;
    private String desc;

    SlotLoginType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
