package cn.com.duiba.tuia.adx.center.api.constant;

import java.util.HashMap;
import java.util.Map;

public enum TuiaSelfActivityTypeEnum {

    OTHER(0, "其他类型"),
    SCRATCH_CARD(1, "刮刮卡"),
    TURN_CIRCLE(2, "大转盘"),
    DOLLMAC(3, "娃娃机"),
    CUT_ROPE(4, "割绳子"),
    SMASHG(6, "砸彩蛋"),
    TIGER(7, "摇奖机"),
    TURN_CARD(8, "翻牌子"),
    FISHING_GOLD(10, "大海捞金"),
    NIU_DAN(11, "扭蛋机"),
    RED_PACKET(12, "扯红包"),
    EXPRESS(13, "拆快递"),
    SET_DOLL(14, "套娃娃"),
    ROLLDICE(15, "摇骰子"),
    DRAW_LOT(17, "摇签"),
    SHOT_ARROW(18, "射箭"),
    DIG_GOLD(19, "挖金矿"),
    CATCH_RABBIT(20, "套兔子"),
    WALLET(21, "卡包"),
    BLOW_BALLOON(23, "吹气球"),
    ADD_PACKET(31, "种红包(深度互动)"),
    DAY_DAY_GARDEN(32, "天天果园(深度互动)"),
    DIG_GOLDS(33, "挖矿(深度互动)"),
    SHENGDU_OTHER(34, "深度其他"),
    TURN_BRAND(35, "红包翻牌子"),
    MONEY_TREE(36, "摇钱树"),
    ANSWER_QUESTION(37, "答题"),
    CANNONY_ATTACK(38, "炮击拿好礼"),
    LUCKY_DRAW(39, "幸运大抽奖"),
    VIOLENT_ATTACK(40, "暴击拿好礼"),
    AGGRGATE_PAGES(41, "聚合页"),
    FISHING_KOI(42, "钓锦鲤"),
    LUCKY_ROLL(43, "幸运翻牌"),
    EGG_TWISTER(44, "扭蛋机"),
    DOLLS_GET(45, "套娃娃"),
    DAY_DAY_SENT(46, "福利天天送"),
    ONE_FLY_DAY(47, "一飞冲天"),
    RICH_MAN(48, "大富翁"),
    LUCKY_EIGHT(49, "幸运八连抽"),
    COLLECT_WORLD(50, "集字摇奖机"),
    ;

    private static Map<Integer, String> typeDescMap = new HashMap<>(64);
    static {
        final TuiaSelfActivityTypeEnum[] values = TuiaSelfActivityTypeEnum.values();
        for (TuiaSelfActivityTypeEnum value : values) {
            typeDescMap.put(value.getType(), value.getDesc());
        }
    }

    private Integer type;
    private String desc;

    TuiaSelfActivityTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        return typeDescMap.get(type);
    }
}
