package cn.com.duiba.tuia.adx.center.api.constant.adx;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 联网方式
 *
 * @author hillchen
 * @create 2019/3/4 22:09
 */
public enum ConnetType {
    UNKNOW(1,"未知"),
    INNET(2,"以太网"),
    WIFI(3,"wifi"),
    G2(4,"2G"),
    G3(5,"3G"),
    G4(6,"4G");

    private int type;

    private String desc;

    ConnetType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isSameType(Integer connectType){
        return Objects.nonNull(connectType) && Objects.equals(type,connectType) || this.equals(UNKNOW);
    }

    public static ConnetType convertLiebaoToTuiaType(Integer liebaoType){
        if(Objects.equals(liebaoType,2)){
            return WIFI;
        }else{
            return UNKNOW;
        }
    }

    /**
     * 推啊字典项都是参考搜狗字典项
     * @param sougouType
     * @return
     */
    public static ConnetType convertSougouToTuiaType(Integer sougouType){
        for(ConnetType connetType:ConnetType.values()){
            if(connetType.isSameType(sougouType)){
                return connetType;
            }
        }
        return UNKNOW;
    }


    /**
     * 推啊字典项都是参考搜狗字典项 :0:unknown 1:WiFi ;2:2G ;3:3G; 4:4G
     * @param mojiType
     * @return
     */
    public static ConnetType convertMojiToTuiaType(Integer mojiType){
        if(Objects.equals(mojiType,1)){
            return WIFI;
        }else if(Objects.equals(mojiType,2)){
            return G2;
        }else if(Objects.equals(mojiType,3)){
            return G3;
        }else if(Objects.equals(mojiType,4)){
            return G4;
        }
        return UNKNOW;
    }
}
