package cn.com.duiba.tuia.adx.center.api.constant.commercial.common;

import java.util.Objects;

/**
 * [深度互动]财务模型单位枚举
 *
 * @author zhangbaiqiang
 * @date 2019-04-23
 */
public enum UnitType {

    CASH(1, "现金-元"),
    COIN(2, "虚拟货币-自定义"),
    ;

    private Integer type;
    private String desc;

    UnitType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        for (UnitType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }
}
